/*******************************************************
Filename		:  	FA_HABITAT_RESULT_tab.sql
Release 		:  	c2.0, C2.0.1, C2.0.4
SIR			:  	1496, 1558, 1647
Description		:  	Creates the FA_HABITAT_RESULT table.
Author			:	Bill Nash
Date			:  	7/07/2003
	10/08/2003 - Added Result BLOB_ID and BLOB_TITLE -JW
	10/29/2003 - Added activity BLOB_ID and BLOB_TITLE -wn
	01/16/04 - SIR 1586 Moved connect string to master install script -JW
	01/21/2003 - Added tsmalp_is_number and fk_stn_act_pt -JW
	06/10/2004 - added new columns for Standard datum - GT
	07/19/2004 - added organization_is_number -JW
	08/28/2044 - change tsruom_is_number to FK_UNIT_CONVERSION -JW
	09/27/2004 - Added fk_statn_types foreign key column. -GT
	12/02/2004 - SIR 1647. Edited pctfree and pctused according to SIR. - GT
	06/07/2005 - SIR1706. Add generatd_huc and related columns. -GT
      08/05/2005 - Added Activity Category and replicate number  -GT
Comments		:  	Created based on Regular Results.
			   	
**********************************************************/
spool FA_HABITAT_RESULT_table.log

drop table FA_HABITAT_RESULT;

CREATE TABLE FA_HABITAT_RESULT (
pk_isn 								number not null,
ORGANIZATION_ID 							CHAR(8),
ORGANIZATION_IS_NUMBER					NUMBER(8),
STATION_ID                      				CHAR(15),
STATION_NAME                                       	VARCHAR2(60),
ACTIVITY_START_DATE_TIME                               	DATE,
ACT_START_TIME_ZONE                                	CHAR(3),
TRIP_ID                                            	CHAR(15),
TRIP_NAME								VARCHAR2(60),
STATION_VISIT_ID                                   	CHAR(3),
CHARACTERISTIC_NAME                                	VARCHAR2(60),
-- NEW HABITAT
HABITAT_CLASS_NAME						VARCHAR2(30),
EPA_REG_NUMBER							VARCHAR2(500),
--
RESULT_VALUE                                       	NUMBER,
RESULT_UNIT                                        	CHAR(10),
RESULT_VALUE_TEXT                                  	CHAR(15),
SAMPLE_FRACTION_TYPE                               	VARCHAR2(15),
RESULT_VALUE_TYPE                                  	CHAR(10),
STATISTIC_TYPE                                     	CHAR(18),
RESULT_VALUE_STATUS                                	CHAR(1),
WEIGHT_BASIS_TYPE                                  	CHAR(12),
TEMPERATURE_BASIS_LEVEL                            	CHAR(8),
DURATION_BASIS                                     	CHAR(10),
--
ANALYTICAL_PROCEDURE_SOURCE                        	CHAR(12),
ANALYTICAL_PROCEDURE_ID                            	CHAR(15),
LAB_ID                                             	CHAR(8),
LAB_NAME                                           	VARCHAR2(60),
LAB_CERTIFIED                                      	CHAR(1),
LAB_BATCH_ID                                       	CHAR(12),
ANALYSIS_DATE_TIME                                     	DATE,
ANALYSIS_TIME_ZONE                                 	CHAR(3),
LOWER_QUANTITATION_LIMIT                           	CHAR(12),
UPPER_QUANTITATION_LIMIT                           	CHAR(12),
DETECTION_LIMIT                                    	VARCHAR2(25),
DETECTION_LIMIT_DESCRIPTION                        	VARCHAR2(254),
LAB_REMARK                                         	VARCHAR2(40),  --check size
DISTANCE_MEASURE_FROM                              	VARCHAR2(20),
DISTANCE_MEASURE_TO                                	VARCHAR2(20),
REPLICATE_ANALYSIS_COUNT                           	NUMBER,
PRECISION                                          	CHAR(12),
CONFIDENCE_LEVEL                                   	CHAR(8),
DILUTION_INDICATOR                                 	CHAR(1),
RECOVERY_INDICATOR                                 	CHAR(1),
CORRECTION_INDICATOR                               	CHAR(1),
STN_LATITUDE                                       	NUMBER,
STN_LONGITUDE                                      	NUMBER,
STN_HDATUM						CHAR(12),
STN_STD_LATITUDE					NUMBER,
STN_STD_LONGITUDE					NUMBER,
STN_STD_HDATUM						CHAR(12),
HYDROLOGIC_UNIT_CODE                               	CHAR(8),
GENERATED_HUC		                               	CHAR(8),
RESULT_IS_NUMBER                                   	NUMBER,
FK_STATION                                         	NUMBER(12),
FK_ORG                                             	NUMBER(12),
FK_DB_CAT                                          	NUMBER(12),
FK_GEN_DB_CAT                                          	NUMBER(12),
FK_GEO_COUNTY                                      	NUMBER(12),
FK_GEO_STATE                                       	NUMBER(12),
FK_MAD_HDATUM                                      	NUMBER(12),
FK_MAD_HMETHOD                                     	NUMBER(12),
FK_DATE_ACT_START                                  	NUMBER(12),
ACTIVITY_IS_NUMBER 						NUMBER(12),  --RSULT.TSRFDACT_IS_NUMBER
FK_CHAR								NUMBER(12),  --RSULT.TSRCHAR_IS_NUMBER
-- ADDED HCSC FOR HABITAT USER CHARS
FK_HCSC								NUMBER(12),  --RSULT.TSRHCSC_IS_NUMBER
-- 
TSMPRMVL_IS_NUMBER 						NUMBER(12),
--
FK_UNIT_CONVERSION						NUMBER(12),
TSRANLPR_IS_NUMBER						NUMBER(12),
TSRANLPR_ORG_ID							CHAR(8),
TSRLSPP_IS_NUMBER							NUMBER(12),
TSRLSPP_ORG_ID							CHAR(8),
TSRLAB_IS_NUMBER							NUMBER(12),
TSRSTVST_IS_NUMBER						NUMBER(12),
TSMSTATN_IS_NUMBER						NUMBER(12),
--start of ACT elements
ACTIVITY_ID                  	                   	CHAR(12),
REPLICATE_NUMBER                                      NUMBER(3),
ACTIVITY_TYPE                                      	CHAR(13),
ACTIVITY_CATEGORY                                     VARCHAR2(30),
LOCATION_POINT_TYPE                                	CHAR(16),
POINT_SEQUENCE_NUMBER                              	NUMBER(5),
WELL_NUMBER                                        	CHAR(15),
PIPE_NUMBER                                        	CHAR(15),
ACTIVITY_STOP_DATE_TIME                                	DATE,
ACT_STOP_TIME_ZONE                                 	CHAR(3),
ACTIVITY_LATITUDE                                  	NUMBER,
ACTIVITY_LONGITUDE                                 	NUMBER,
ACT_STD_LATITUDE					NUMBER,
ACT_STD_LONGITUDE					NUMBER,
ACT_STD_HDATUM					CHAR(12),
tsrfldpr_is_number						NUMBER(12),
tsrgrcfg_is_number						NUMBER(12),
STD_VALUE                                       	NUMBER,
STD_UNIT                                        	VARCHAR2(10),
fk_act_mad_hdatum                          		number(12),
fk_act_mad_hmethod                         		number(12),
activity_isn 							number,
VISIT_START_DATE_TIME							DATE,
VISIT_START_TIME_ZONE						CHAR(3),
VISIT_STOP_DATE_TIME							DATE,
VISIT_STOP_TIME_ZONE						CHAR(3),
FIELD_SET								VARCHAR2(130),
POINT_NAME								VARCHAR2(30),
SGO_INDICATOR							CHAR(1),
MAP_SCALE						VARCHAR2(20),
BIAS							CHAR(12),
CONF_LVL_CORR_BIAS					CHAR(1),
TSRFLDGR_IS_NUMBER					NUMBER(12),
TSRMATRX_IS_NUMBER					NUMBER(12),
RESULT_COMMENT						VARCHAR2(4000),
TEXT_RESULT						VARCHAR2(4000),
tsmalp_is_number					NUMBER(12),
fk_stn_act_pt						NUMBER(12),
fk_statn_types						number(12)
) tablespace STORETDATA
storage(initial 100M next 25M)
nologging
pctused 40 pctfree 60;
--storage(initial 300M next 300M minextents 2 maxextents 200)

alter table fa_habitat_result add blob_id varchar2(25);
alter table fa_habitat_result add blob_title varchar2(60);
alter table fa_habitat_result add act_blob_id varchar2(25);
alter table fa_habitat_result add act_blob_title varchar2(60);

spool off;